/******************************************************************************/
#include "stdafx.h"
#include "../../../../../data/enum/_enums.h"
/******************************************************************************/
Game::ObjMemx<Game::Static> Statics; // container for static objects
Game::ObjMemx<Game::Chr   > Chrs   ; // container for player objects
/******************************************************************************/
void InitPre()
{
   App.name="Character Ragdoll";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).sync(true).shdMapSize(1024).shdSoft(1).ambPower(0.3);
   ViewportFull.range=30;

   Cam.at.set(16,0,16);
   Cam.yaw   =-PI_4;
   Cam.pitch =-0.5;
   Cam.dist  =4;
}
/******************************************************************************/
Bool Init()
{
   Physics.create();
   Sky    .set   ();
   Sun    .set   (*Gfxs("gfx/sky/sun.gfx")).power=1-D.ambPower();

   // create the world
   Game::World.init()
              .setType(Statics,OBJ_STATIC)
              .setType(Chrs   ,OBJ_CHR   )
              .New    ("world/sample"    );

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;

   Game::World.update(Cam.at);

   if(Chrs.elms())
   {
      Game::Chr &chr=Chrs[0];

      if(Kb.bp(KB_1))chr.ragdollEnable (); // switch to ragdoll
      if(Kb.bp(KB_2))chr.ragdollDisable(); // switch to skeleton animation

      if(Kb.bp(KB_Q))if(chr.ragdollBlend())if(Actor *actor=chr.ragdoll.findActor("Head" ))actor->addVel(Vec(0,0,3));
      if(Kb.bp(KB_W))if(chr.ragdollBlend())if(Actor *actor=chr.ragdoll.findActor("Body" ))actor->addVel(Vec(0,0,3));
      if(Kb.bp(KB_E))if(chr.ragdollBlend())if(Actor *actor=chr.ragdoll.findActor("FootR"))actor->addVel(Vec(0,0,4));
      if(Kb.bp(KB_R))if(chr.ragdollBlend())if(Actor *actor=chr.ragdoll.findActor("HandR"))actor->addVel(Vec(0,0,4));

      Cam.setSpherical(chr.pos(),Cam.yaw-Ms.d.x,Cam.pitch+Ms.d.y,0,Max(0.1f,Cam.dist*ScaleMul(Ms.wheel*-0.2))).updateVelocities().set();
   }

   return true;
}
/******************************************************************************/
void Render()
{
   Game::World.draw();
}
void Draw()
{
   Renderer(Render);

   D.text(0,0.9,"Press 1,2 to switch between skeleton<->ragdoll animation");
   D.text(0,0.8,"Press q,w,e,r to simulate shot hits");
}
/******************************************************************************/
